
badeline = nil
badeline_orb = nil
local celeste = require("#Celeste")
local carpetMod = require("#celeste.mod.carpet")
-- Debug function to print values
--local function debugPrint(message)
    --say(message)
--end

local function badeline_appears(left_side, pos_x, pos_y)
    -- determine the position and flipping properties
    local scale
    if left_side then
        scale = 1
    else
        scale = -1
    end

    -- Debug messages
    --debugPrint("Creating Badeline at position: " .. pos_x .. ", " .. pos_y)

    -- create and add a new badeline dummy entity
    local position = vector2(pos_x, pos_y)
    badeline = celeste.BadelineDummy(position)
    if badeline then
        badeline.Sprite.Scale = vector2(scale, 1.0)
        getLevel():Add(badeline)

        -- play sound + effect
        getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
        playSound("event:/char/badeline/maddy_split", badeline.Position)

        -- wait until the next frame so all that can take effect properly
        --wait()
    else
        --debugPrint("Failed to create Badeline entity.")
    end
end

local function badeline_orb_appears(left_side, pos_x, pos_y)

    -- Debug messages
    --debugPrint("Creating Badeline orb at position: " .. pos_x .. ", " .. pos_y)
    --say("Creating Badeline orb at position: " .. pos_x .. ", " .. pos_y)
    -- create and add a new badeline dummy entity
    local position = vector2(pos_x, pos_y)
    badeline_orb = getFirstEntity("BadelineBoost")
    badeline_orb.Visible = true
    badeline_orb.Active = true
    --getLevel().Displacement:AddBurst(badeline_orb.Position, 0.5, 8, 32, 0.5)
    --badeline_orb.nodes[2] = position
    --badeline_orb = celeste.BadelineBoost({position}, false, false, false, false, false)
    --badeline_orb = carpetMod.boost(position)
    --local position = { x = pos_x, y = pos_y }
    --local badeline_orb = celeste.Level:SpawnEntity("carpet/boost", position.x, position.y)
    --if not badeline_orb then
      --say("BadelineBoost creation failed.")
    --else  
      --say("BadelineBoost creation not failed.")
    --end
    if badeline_orb then
        --badeline_orb.Sprite.Scale = vector2(1.0, 1.0)
        --getLevel():Add(badeline_orb)

        -- play sound + effect
        -- playSound("event:/char/badeline/maddy_split", badeline_orb.Position)

        -- wait until the next frame so all that can take effect properly
        --wait()
    else
        --debugPrint("Failed to create Badeline orb entity.")
    end
end

local function badeline_orb_vanishes(left_side, pos_x, pos_y, show_burst)

  -- Debug messages
  --debugPrint("Creating Badeline orb at position: " .. pos_x .. ", " .. pos_y)
  --say("Creating Badeline orb at position: " .. pos_x .. ", " .. pos_y)
  --- create and add a new badeline dummy entity
  local position = vector2(pos_x, pos_y)
  badeline_orb = getFirstEntity("BadelineBoost")
  badeline_orb.Visible = false
  badeline_orb.Active = false
  if show_burst then
    getLevel().Displacement:AddBurst(vector2(pos_x, pos_y), 0.5, 8, 32, 0.5)
  end
  --badeline_orb.nodes[2] = position
  --badeline_orb = celeste.BadelineBoost({position}, false, false, false, false, false)
  --badeline_orb = carpetMod.boost(position)
  --local position = { x = pos_x, y = pos_y }
  --local badeline_orb = celeste.Level:SpawnEntity("carpet/boost", position.x, position.y)
  --if not badeline_orb then
    --say("BadelineBoost creation failed.")
  --else  
    --say("BadelineBoost creation not failed.")
  --end
  if badeline_orb then
      --badeline_orb.Sprite.Scale = vector2(1.0, 1.0)
      --getLevel():Add(badeline_orb)

      -- play sound + effect
      -- playSound("event:/char/badeline/maddy_split", badeline_orb.Position)

      -- wait until the next frame so all that can take effect properly
      --wait()
  else
      --debugPrint("Failed to create Badeline orb entity.")
  end
end

function badeline_vanishes(show_burst)
    if badeline then
        if show_burst then
            badeline:Vanish()
            -- Input.Rumble(getEnum("Celeste.RumbleStrength", "Medium"), getEnum("Celeste.RumbleLength", "Medium"))
        else
            badeline:RemoveSelf()
        end
        badeline = nil
        --wait()
    else
        --debugPrint("No Badeline entity to vanish.")
    end
end
function show_burst(pos_x, pos_y)
  badeline_appears(false, pos_x, pos_y, false)
  wait()
  badeline_vanishes(true)
end
function onBegin(room)
    --debugPrint("Cutscene begun.")
    disableMovement()
    badeline_orb_vanishes(false, 680, -1272)
    badeline_appears(false, 648, -1280, false)
    say("ST_B1")
    badeline_vanishes(true)
    show_burst(680,-1272)
    badeline_orb_appears(false, 680, -1272)
    --getLevel().Displacement:AddBurst(vector2(680, -1272), 0.5, 8, 32, 0.5)
end

function onEnd(room, wasSkipped)
    --debugPrint("Cutscene ended. Was skipped: " .. tostring(wasSkipped))
    if wasSkipped then
        enableMovement()
        badeline_vanishes(false)
        badeline_orb_appears(false, 160, 128)
    end
    enableMovement()
end

function onLeave(player)
    --debugPrint("Leaving cutscene.")
    --badeline_vanishes(false)
end
