local vector2 = require("#microsoft.xna.framework.vector2")

local openedBoxFlag = "opened_pandoras_box"
local musicEvent = "event:/SC2020_Cruor"
local openedDialogId = "SpringCollab2020Cruor_opening_pandoras_box_3"
local normalDialogId = "SpringCollab2020Cruor_dream_dash_tutorial_dialog"

local function setMusicIfNotStarted(event)
    if getMusic() ~= event then
        playMusic(event)
    end
end

local function setTutorialBird(id, state)
    local birds = getEntities("Mod.SpringCollab2020.Entities.CustomBirdTutorial")

    for _, bird in ipairs(birds) do
        if bird.BirdId == id then
            if state then
                bird:TriggerShowTutorial()

            else
                bird:TriggerHideTutorial()
            end
        end
    end
end

function onBegin()
    celeste.Glitch.Value = 0.0
    celeste.Distort.Anxiety = 0.0

    if getFlag(openedBoxFlag) then
        if not getFlag(openedDialogId) then
            disableMovement()

            setMusicIfNotStarted(musicEvent)
            say(openedDialogId)
            setFlag(openedDialogId, true)
        end
    end
end

function onEnd(level, wasSkipped)
    if getFlag(openedBoxFlag) then
        setMusicIfNotStarted(musicEvent)
    end

    setTutorialBird("dream_dash_tutorial", true)
    enableMovement()
end