local vector2 = require("#microsoft.xna.framework.vector2")

local cameraTriggerRightX = getLevel().Bounds.Left + 1256
local cameraTriggerRightY = getLevel().Bounds.Top + 0

local cameraTriggerLeftX = getLevel().Bounds.Left + 1256
local cameraTriggerLeftY = getLevel().Bounds.Top + 40

local cutsceneTriggerX = cutsceneTrigger.Position.X
local cutsceneTriggerY = cutsceneTrigger.Position.Y

local cameraTriggerRight
local cameraTriggerLeft

function onBegin()
    makeUnskippable()

    for _, entity in ipairs(getAllEntities("Mod.Entities.SmoothCameraOffsetTrigger")) do
        if entity.Position.X == cameraTriggerRightX and entity.Position.Y == cameraTriggerRightY then
            cameraTriggerRight = entity
        end

        if entity.Position.X == cameraTriggerLeftX and entity.Position.Y == cameraTriggerLeftY then
            cameraTriggerLeft = entity
        end
    end

    if cameraTriggerLeft then
        cameraTriggerLeft.Position = vector2(cutsceneTriggerX, cutsceneTriggerY)
    end

    -- Keep alive
    while true do
        wait(15 / 60)
    end
end

function onStay(player)
    local goingLeft = player.DashDir.X < 0 and getPlayerState() == 9

    if cameraTriggerRight then
        if goingLeft then
            cameraTriggerRight.Position = vector2(cutsceneTriggerX, cutsceneTriggerY)

        else
            cameraTriggerRight.Position = vector2(cameraTriggerRightX, cameraTriggerRightY)
        end
    end

    if cameraTriggerLeft then
        if goingLeft then
            cameraTriggerLeft.Position = vector2(cameraTriggerLeftX, cameraTriggerLeftY)

        else
            cameraTriggerLeft.Position = vector2(cutsceneTriggerX, cutsceneTriggerY)
        end
    end
end

function onLeave(player)
    if cameraTriggerRight then
        cameraTriggerRight.Position = vector2(cameraTriggerRightX, cameraTriggerRightY)
    end

    if cameraTriggerLeft then
        cameraTriggerLeft.Position = vector2(cutsceneTriggerX, cutsceneTriggerY)
    end
end