local function distance(x1, y1, x2, y2)
    return math.sqrt((x1 - x2)^2  + (y1 - y2)^2)
end

function onBegin()
    makeUnskippable()

    local closest
    local closestDist = math.huge

    local followersOnEnter = player.Leader.Followers.Count
    local berryFollowing = false

    while not berryFollowing do
        local following = player.Leader.Followers.Count

        if following > followersOnEnter then
            for _, entity in ipairs(getAllEntities("DashBlock")) do
                local dist = distance(player.Position.X, player.Position.Y, entity.Position.X + entity.Width / 2, entity.Position.Y + entity.Height / 2)

                if dist < closestDist then
                    closest = entity
                    closestDist = dist
                end
            end

            if closest then
                closest:Break(vector2(closest.X + closest.Width / 2, closest.Y + closest.Height / 2), vector2(0, 1))
            end

            berryFollowing = true
        end

        wait(0.1)
    end
end

function onEnd(level, wasSkipped)

end