local enums = require("consts.celeste_enums")

local default = {}

local versionCheck = require("mods").requireFromPlugin("libraries.MoreLoennPlugins.versionCheck")
if not versionCheck.validModVersion("Sardine7", "1.1.4")
  then return {}
end
default.associatedMods = { "Sardine7" }

default.name = "Sardine7/SmoothieCameraTargetTrigger"
default.placements = {
    name = "default",
    data = {
        deleteFlag = "",
        xLerpStrength = 0.0,
        yLerpStrength = 0.0,
        positionMode = "NoEffect",
        xOnly = false,
        yOnly = false
    }
}

default.nodeLimits = {1, 1}

default.fieldInformation = {
    positionMode = {
        options = enums.trigger_position_modes,
        editable = false
    }
}

return default