local forceVariantTrigger = {}

local versionCheck = require("mods").requireFromPlugin("libraries.MoreLoennPlugins.versionCheck")
if not versionCheck.validModVersion("IsaGrabBag", "1.6.14")
  then return {}
end
forceVariantTrigger.associatedMods = { "IsaGrabBag" }

forceVariantTrigger.name = "isaBag/forceVariantTrigger"
forceVariantTrigger.fieldInformation = {
    variants = {
        options = {
			"Hiccups",
			"InfiniteStamina",
			"Invincible",
			"InvisibleMotion",
			"LowFriction",
			"MirrorMode",
			"NoGrabbing",
			"PlayAsBadeline",
			"SuperDashing",
			"ThreeSixtyDashing",
			"DashAssist"
        },
        editable = false,
    },
    variantMod = {
        options = {
			"Enabled",
			"Disabled",
			"EnabledPermanent",
			"DisabledPermanent",
			"EnabledTemporary",
			"DisabledTemporary",
			"Toggle",
			"SetToDefault"
        },
        editable = false
    }
}

forceVariantTrigger.fieldOrder = {
    "x", "y",
    "width", "height", 
    "variants", "variantMod"
}

return forceVariantTrigger