local enums = require("consts.celeste_enums")
local coreWindTrigger = {}

local versionCheck = require("mods").requireFromPlugin("libraries.MoreLoennPlugins.versionCheck")
if not versionCheck.validModVersion("IsaGrabBag", "1.6.14")
  then return {}
end
coreWindTrigger.associatedMods = { "IsaGrabBag" }

coreWindTrigger.name = "isaBag/coreWindTrigger"
coreWindTrigger.placements = {
    name = "default",
    data = {
        patternCold = "None",
        patternHot = "None"
    }
}

coreWindTrigger.fieldInformation = {
    patternCold = {
        options = enums.wind_patterns,
        editable = false
    },
    patternHot = {
        options = enums.wind_patterns,
        editable = false
    }
}

coreWindTrigger.fieldOrder = {
    "x", "y",
    "width", "height", 
    "patternCold", "patternHot"
}

return coreWindTrigger