local default = {}

local versionCheck = require("mods").requireFromPlugin("libraries.MoreLoennPlugins.versionCheck")
if not versionCheck.validModVersion("HonlyHelper", "1.7.4")
  then return {}
end
default.associatedMods = { "HonlyHelper" }

default.name = "HonlyHelper/TurretController"
default.placements = {
    name = "default",
    data = {
        turretID = "TurretID",
        turretAction = "HeliFadeIn"
    }
}

default.fieldInformation = {
    turretAction = {
        options = {
            "HeliFadeIn",
            "HeliOn",
            "HeliLeave",
            "GunOnlyOn",
            "GunOnlyOff"
        },
        editable = false
    }
}

default.fieldOrder = {
    "x", "y",
    "width", "height",
    "turretID", "turretAction"
}

return default