local default = {}

local versionCheck = require("mods").requireFromPlugin("libraries.MoreLoennPlugins.versionCheck")
if not versionCheck.validModVersion("HonlyHelper", "1.7.4")
  then return {}
end
default.associatedMods = { "HonlyHelper" }

default.name = "HonlyHelper/CameraTargetCornerTrigger"
default.placements = {
    name = "default",
    data = {
        deleteFlag = "",
        lerpStrength = 0.0,
        positionMode = "BottomLeft",
        xOnly = false,
        yOnly = false
    }
}

default.nodeLimits = {1, 1}
default.nodeVisibility = "selected"
default.nodeLineRenderType = "line"

default.fieldInformation = {
    positionMode = {
        options = {
            "BottomLeft",
            "BottomRight",
            "TopLeft",
            "TopRight"
        },
        editable = false
    }
}

default.fieldOrder = {
    "x", "y",
    "width", "height",
    "positionMode", "lerpStrength",
    "deleteFlag", "xOnly", "yOnly"
}

return default