local PlacementFeatureTrigger = {}

local versionCheck = require("mods").requireFromPlugin("libraries.MoreLoennPlugins.versionCheck")
if not versionCheck.validModVersion("ChineseNewYear2023Helper", "1.0.1")
  then return {}
end
PlacementFeatureTrigger.associatedMods = { "ChineseNewYear2023Helper" }

PlacementFeatureTrigger.name = "ChineseNewYear2023Helper/POMRPlacementFeatureTrigger"
PlacementFeatureTrigger.placements = {
    name = "default",
    data = {
        money = 0,
        buyJellyFishCount = 0,
        buyJellyFishCost = 0,
        buyTheoCount = 0,
        buyTheoCost = 0,
        buySpaceJamCount = 0,
        buySpaceJamCost = 0,
        buyStrawberryCount = 0,
        buyStrawberryCost = 0,
        buyRightSpringCount = 0,
        buyRightSpringCost = 0,
        buyCrumbleBlock2Count = 0,
        buyCrumbleBlock2Cost = 0,
        buyCrumbleBlock6Count = 0,
        buyCrumbleBlock6Cost = 0,
        buyRenewableSingleDashRefillCount = 0,
        buyRenewableSingleDashRefillCost = 0,
        buyOneUseSingleDashRefillCount = 0,
        buyOneUseSingleDashRefillCost = 0,
        buyRenewableDoubleDashRefillCount = 0,
        buyRenewableDoubleDashRefillCost = 0,
        buyOneUseDoubleDashRefillCount = 0,
        buyOneUseDoubleDashRefillCost = 0,
        buySeekerCount = 0, 
        buySeekerCost = 0,
        buyGreenBubbleCount = 0,
        buyGreenBubbleCost = 0,
        buyRedBubbleCount = 0,
        buyRedBubbleCost = 0,
        configSpaceJamIntegralPoint = true
    }
}

PlacementFeatureTrigger.fieldInformation = {
    buyJellyFishCount = {
        fieldType = "integer"
    },
    buyJellyFishCost = {
        fieldType = "integer"
    },
    buyTheoCount = {
        fieldType = "integer"
    },
    buyTheoCost = {
        fieldType = "integer"
    },
    buySpaceJamCount = {
        fieldType = "integer"
    },
    buySpaceJamCost = {
        fieldType = "integer"
    },
    buyStrawberryCount = {
        fieldType = "integer"
    },
    buyStrawberryCost = {
        fieldType = "integer"
    },
    buyRightSpringCount = {
        fieldType = "integer"
    },
    buyRightSpringCost = {
        fieldType = "integer"
    },
    buyCrumbleBlock2Count = {
        fieldType = "integer"
    },
    buyCrumbleBlock2Cost = {
        fieldType = "integer"
    },
    buyCrumbleBlock6Count = {
        fieldType = "integer"
    },
    buyCrumbleBlock6Cost = {
        fieldType = "integer"
    },
    buyOneUseSingleDashRefillCount = {
        fieldType = "integer"
    },
    buyOneUseSingleDashRefillCost = {
        fieldType = "integer"
    },
    buyOneUseDoubleDashRefillCount = {
        fieldType = "integer"
    },
    buyOneUseDoubleDashRefillCost = {
        fieldType = "integer"
    },
    buyRenewableSingleDashRefillCount = {
        fieldType = "integer"
    },
    buyRenewableSingleDashRefillCost = {
        fieldType = "integer"
    },
    buyRenewableDoubleDashRefillCount = {
        fieldType = "integer"
    },
    buyRenewableDoubleDashRefillCost = {
        fieldType = "integer"
    },
    buySeekerCount = {
        fieldType = "integer"
    },
    buySeekerCost = {
        fieldType = "integer"
    },
    buyGreenBubbleCount = {
        fieldType = "integer"
    },
    buyGreenBubbleCost = {
        fieldType = "integer"
    },
    buyRedBubbleCount = {
        fieldType = "integer"
    },
    buyRedBubbleCost = {
        fieldType = "integer"
    }
}

PlacementFeatureTrigger.fieldOrder = {
    "x", "y",
    "width", "height",
    "buyJellyFishCount", "buyJellyFishCost",
    "buyTheoCount", "buyTheoCost",
    "buySpaceJamCount", "buySpaceJamCost",
    "buyStrawberryCount", "buyStrawberryCost",
    "buyRightSpringCount", "buyRightSpringCost",
    "buyCrumbleBlock2Count", "buyCrumbleBlock2Cost",
    "buyCrumbleBlock6Count", "buyCrumbleBlock6Cost",
    "buyOneUseSingleDashRefillCount", "buyOneUseSingleDashRefillCost",
    "buyOneUseDoubleDashRefillCount", "buyOneUseDoubleDashRefillCost",
    "buyRenewableSingleDashRefillCount", "buyRenewableSingleDashRefillCost",
    "buyRenewableDoubleDashRefillCount", "buyRenewableDoubleDashRefillCost",
    "buySeekerCount", "buySeekerCost",
    "buyGreenBubbleCount", "buyGreenBubbleCost",
    "buyRedBubbleCount", "buyRedBubbleCost",
    "money", "configSpaceJamIntegralPoint"
}

return PlacementFeatureTrigger