local drawableSpriteStruct = require("structs.drawable_sprite")
local drawing = require("utils.drawing")
local utils = require("utils")

local fungus = {}

local versionCheck = require("mods").requireFromPlugin("libraries.MoreLoennPlugins.versionCheck")
if not versionCheck.validModVersion("SusanHelper", "1.1.0")
  then return {}
end
fungus.associatedMods = { "SusanHelper" }

fungus.name = "SusanHelper/BigFungus"
fungus.depth = 0
fungus.placements = {
    name = "fungus",
    data = {
        width = 8,
        hitSpd = 200,
        type = "Green"
    }
}

fungus.fieldInformation = {
   type = {
        options = {
            "Red",
            "Orange",
            "Green",
            "Blue",
            "Cyan"
        },
        editable = false
    }
}

function fungus.sprite(room, entity)
    local textureRaw = getTexture(entity)
    local texture = "objects/bigFungus/gmush" .. textureRaw

    local x, y = entity.x or 0, entity.y or 0
    local width = entity.width or 8

    local startX, startY = math.floor(x / 8) + 1, math.floor(y / 8) + 1
    local stopX = startX + math.floor(width / 8) - 1
    local len = stopX - startX

    local sprites = {}

    for i = 0, len do
        local quadX = 8
        local quadY = 8

        if i == 0 then
            quadX = 0
            quadY = room.tilesFg.matrix:get(startX - 1, startY, "0") ~= "0" and 0 or 8

        elseif i == len then
            quadY = room.tilesFg.matrix:get(stopX + 1, startY, "0") ~= "0" and 0 or 8
            quadX = 16
        end

        local sprite = drawableSpriteStruct.fromTexture(texture, entity)

        sprite:setJustification(0, 0)
        sprite:addPosition(i * 8, 0)
        sprite:useRelativeQuad(quadX, quadY, 8, 8)

        table.insert(sprites, sprite)
    end

    return sprites
end

function fungus.selection(room, entity)
    return utils.rectangle(entity.x, entity.y, entity.width, 8)
end

return fungus