local default = {}

local versionCheck = require("mods").requireFromPlugin("libraries.MoreLoennPlugins.versionCheck")
if not versionCheck.validModVersion("Sardine7", "1.1.4")
  then return {}
end
default.associatedMods = { "Sardine7" }

default.name = "Sardine7/SwitchMover"
default.depth = 0
default.placements = {
    {
        name = "default",
        data = {
            width = 16,
            height = 16,
            pathDepth = 5000,
            flag = "",
            theme = "Normal"
        }
    },
    {
        name = "moon",
        data = {
            width = 16,
            height = 16,
            pathDepth = 5000,
            flag = "",
            theme = "Moon"
        }
    }
}

default.fieldInformation = {
    theme = {
	    options = {
            "Normal",
            "Moon"
        }
	}
}

default.nodeLimits = {1, 1}
default.nodeVisibility = "always"
default.nodeLineRenderType = "line"

default.fillColor = {0.65, 0.68, 0.6, 0.4}
default.borderColor = {0.0, 0.0, 0.0, 1.0}

return default

--todo: texture