local fakeTilesHelper = require("helpers.fake_tiles")

local default = {}

local versionCheck = require("mods").requireFromPlugin("libraries.MoreLoennPlugins.versionCheck")
if not versionCheck.validModVersion("Sardine7", "1.1.4")
  then return {}
end
default.associatedMods = { "Sardine7" }

default.name = "Sardine7/SturdyFakeWall"
default.depth = 0
default.placements = {
    name = "default",
    data = {
        width = 8,
        height = 8,
        revealSound = "event:/game/general/secret_revealed",
        tiletype = "3",
        blendin = true,
        permanent = true,
        playNormalReveal = true,
        playTransitionReveal = false
    }
}

default.sprite = fakeTilesHelper.getEntitySpriteFunction("tiletype", true, "tilesFg", {1.0, 1.0, 1.0, 0.7})
default.fieldInformation = fakeTilesHelper.getFieldInformation("tiletype")

return default