local default = {}
local enums = require("consts.celeste_enums")

local versionCheck = require("mods").requireFromPlugin("libraries.MoreLoennPlugins.versionCheck")
if not versionCheck.validModVersion("Sardine7", "1.1.4")
  then return {}
end
default.associatedMods = { "Sardine7" }

default.name = "Sardine7/SokobanBlock"
default.depth = 0
default.placements = {
    name = "default",
    data = {
        width = 24,
        height = 24,
        axes = "both"
    }
}

default.fieldInformation = {
    axes = {
        options = enums.kevin_axes,
        editable = false
    }
}

default.fillColor = {0.68, 0.44, 0.0, 0.4}
default.borderColor = {0.0, 0.0, 0.0, 1.0}

return default

--todo: texture