local light = {}

local versionCheck = require("mods").requireFromPlugin("libraries.MoreLoennPlugins.versionCheck")
if not versionCheck.validModVersion("Sardine7", "1.1.4")
  then return {}
end
light.associatedMods = { "Sardine7" }

light.name = "Sardine7/LightSource"
light.texture = "objects/Sardine7/LightSource/hanginglamp_extended"
light.depth = 0
light.placements = {
    name = "default",
    data = {
        alpha = 1.0,
        radius = 48.0,
        startFade = 24.0,
        endFade = 48.0,
        color = "White"
    }
}

light.fieldInformation = {
    color = {
        fieldType = "color"
    }
}

return light