local default = {}

local versionCheck = require("mods").requireFromPlugin("libraries.MoreLoennPlugins.versionCheck")
if not versionCheck.validModVersion("Sardine7", "1.1.4")
  then return {}
end
default.associatedMods = { "Sardine7" }

default.name = "Sardine7/ChainMover"
default.depth = 0
default.placements = {
    {
        name = "default",
        data = {
            width = 16,
            height = 16,
            theme = "Normal"
        }
    },
    {
        name = "moon",
        data = {
            width = 16,
            height = 16,
            theme = "Moon"
        }
    }
}

default.fieldInformation = {
    theme = {
	    options = {
            "Normal",
            "Moon"
        }
	}
}

default.nodeLimits = {2, -1}
default.nodeVisibility = "always"
default.nodeLineRenderType = "line"

default.fillColor = {0.65, 0.68, 0.6, 0.4}
default.borderColor = {0.52, 0.46, 0.42, 1.0}

return default

--todo: texture