local drawableSpriteStruct = require("structs.drawable_sprite")
local drawing = require("utils.drawing")
local utils = require("utils")


local Fish = {}

local versionCheck = require("mods").requireFromPlugin("libraries.MoreLoennPlugins.versionCheck")
if not versionCheck.validModVersion("JackalHelper", "1.6.8")
  then return {}
end
Fish.associatedMods = { "JackalHelper" }

Fish.name = "JackalHelper/LongFish"
Fish.depth = 0
Fish.placements = {
    name = "default",
    data = {
        width = 8,
        oscillationScale = 80,
        oscillationTerms = 3,
        oscillationSpeed = 10,
        riseRate = 20,
        maxRiseSpeed = 160
    }
}

-- make it appear as a solid red texture because i have no idea how to make the jump thru effect
function Fish.sprite(room, entity)
    local textureRaw = getTexture(entity)
    local texture = "objects/longFish/texture" .. textureRaw

    local x, y = entity.x or 0, entity.y or 0
    local width = entity.width or 8

    local startX, startY = math.floor(x / 8) + 1, math.floor(y / 8) + 1
    local stopX = startX + math.floor(width / 8) - 1
    local len = stopX - startX

    local sprites = {}

    for i = 0, len do
        local quadX = 8
        local quadY = 8

        if i == 0 then
            quadX = 0
            quadY = room.tilesFg.matrix:get(startX - 1, startY, "0") ~= "0" and 0 or 8

        elseif i == len then
            quadY = room.tilesFg.matrix:get(stopX + 1, startY, "0") ~= "0" and 0 or 8
            quadX = 16
        end

        local sprite = drawableSpriteStruct.fromTexture(texture, entity)

        sprite:setJustification(0, 0)
        sprite:addPosition(i * 8, 0)
        sprite:useRelativeQuad(quadX, quadY, 8, 8)

        table.insert(sprites, sprite)
    end

    return sprites
end

function Fish.selection(room, entity)
    return utils.rectangle(entity.x, entity.y, entity.width, 8)
end

return Fish