local OWJellyBarrier = {}

local versionCheck = require("mods").requireFromPlugin("libraries.MoreLoennPlugins.versionCheck")
if not versionCheck.validModVersion("JackalHelper", "1.6.8")
  then return {}
end
OWJellyBarrier.associatedMods = { "JackalHelper" }

OWJellyBarrier.name = "JackalHelper/OWJellyBarrier"
OWJellyBarrier.placements = {
    name = "default",
    data = {
        width = 8,
        height = 8,
        alpha = 0.5,
        color = "ffffff",
        direction = "Up",
        ignoreOnHeld = false
    }
}

OWJellyBarrier.fillColor = {0.75, 0.75, 0.25, 0.8}
OWJellyBarrier.borderColor = {0.0, 0.0, 0.0, 0.0}

OWJellyBarrier.fieldInformation = {
    color = {
        fieldType = "color"
    },
    direction = {
        options = {
            "Up",
            "Down",
            "Left",
            "Right"
        }
    }
}

return OWJellyBarrier