local CryoLava = {}

local versionCheck = require("mods").requireFromPlugin("libraries.MoreLoennPlugins.versionCheck")
if not versionCheck.validModVersion("JackalHelper", "1.6.8")
  then return {}
end
CryoLava.associatedMods = { "JackalHelper" }

CryoLava.name = "JackalHelper/CryoLava"
CryoLava.placements = {
    name = "default",
    data = {
        width = 8,
        height = 8,
        centerColor = "d01c01",
        edgeColor = "f25e29",
        surfaceColor = "ff8933",
        linSpeedX = 0,
        linSpeedY = 0,
        sineAmplitudeX = 0,
        sineAmplitudeY = 0,
        sineFrequencyX = 0,
        sineFrequencyY = 0,
        isIce = false,
        linearMotion = false,
        sineMotion = false
    }
}

CryoLava.fillColor = {0.2, 0.2, 0.2, 0.4}
CryoLava.borderColor = {0.1, 0.1, 0.1, 1.0}

CryoLava.fieldInformation = {
    centerColor = {
        fieldType = "color"
    },
    edgeColor = {
        fieldType = "color"
    },
    surfaceColor = {
        fieldType = "color"
    }
}

return CryoLava