local drawableSprite = require("structs.drawable_sprite")
local utils = require("utils")

local LinkedCardinalBumper = {}

local versionCheck = require("mods").requireFromPlugin("libraries.MoreLoennPlugins.versionCheck")
if not versionCheck.validModVersion("JackalHelper", "1.6.8")
  then return {}
end
LinkedCardinalBumper.associatedMods = { "JackalHelper" }

LinkedCardinalBumper.name = "JackalHelper/LinkedCardinalBumper"
LinkedCardinalBumper.depth = 0
LinkedCardinalBumper.placements = {
    name = "default",
    data = {
        alwaysBumperBoost = false,
        wobble = false,
        spriteDirectory = "bumperCardinal"
    }
}

function LinkedCardinalBumper.sprite(room, entity)
    return drawableSprite.fromTexture("objects/" .. entity.spriteDirectory .. "/Idle00", entity)
end

LinkedCardinalBumper.nodeLimits = {0, -1}

return LinkedCardinalBumper