local arrowBubble = {}

local versionCheck = require("mods").requireFromPlugin("libraries.MoreLoennPlugins.versionCheck")
if not versionCheck.validModVersion("IsaGrabBag", "1.6.14")
  then return {}
end
arrowBubble.associatedMods = { "IsaGrabBag" }

arrowBubble.name = "isaBag/arrowBubble"
arrowBubble.depth = -100
arrowBubble.placements = {
    {
        name = "left",
        data = {
            direction = "left"
        }
    },
        {
        name = "right",
        data = {
            direction = "right"
        }
    },
        {
        name = "up",
        data = {
            direction = "up"
        }
    },
        {
        name = "down",
        data = {
            direction = "down"
        }
    }
}

arrowBubble.fieldInformation = {
    direction = {
        options = {
            "left",
            "right",
            "up",
            "down"
        },
        editable = false
    }
}

function arrowBubble.texture(room, entity)
    return entity.direction and "isafriend/objects/booster/booster" .. entity.direction .. "00"
end

return arrowBubble
