local fakeTilesHelper = require("helpers.fake_tiles")

local default = {}

local versionCheck = require("mods").requireFromPlugin("libraries.MoreLoennPlugins.versionCheck")
if not versionCheck.validModVersion("HonlyHelper", "1.7.4")
  then return {}
end
default.associatedMods = { "HonlyHelper" }

default.name = "HonlyHelper/FloatyBgTile"
default.depth = 0
default.placements = {
    name = "default",
    data = {
        width = 8,
        height = 8,
        tiletype = "3",
        disableSpawnOffset = false
    }
}

default.sprite = fakeTilesHelper.getEntitySpriteFunction("tiletype", true, "tilesBg", {1.0, 1.0, 1.0, 0.7})

default.fieldOrder = {
    "x", "y",
    "width", "height",
    "tiletype", "disableSpawnOffset"
}

return default