local enums = require("consts.celeste_enums")

local default = {}

local versionCheck = require("mods").requireFromPlugin("libraries.MoreLoennPlugins.versionCheck")
if not versionCheck.validModVersion("HonlyHelper", "1.7.4")
  then return {}
end
default.associatedMods = { "HonlyHelper" }

default.name = "HonlyHelper/FlagSoundSource"
default.texture = "@Internal@/sound_source"
default.depth = 0
default.placements = {
    name = "default",
    data = {
        sound = "env_loc_10_kevinpc",
        allowFade = false,
        flag = "flag"
    }
}

default.fieldInformation = {
    track = {
        options = enums.environmental_sounds,
        editable = true
    }
}

default.fieldOrder = {
    "x", "y",
    "flag", "sound",
    "allowFade"
}

return default