local drawableSprite = require("structs.drawable_sprite")
local utils = require("utils")

local reverse_booster = {}

local versionCheck = require("mods").requireFromPlugin("libraries.MoreLoennPlugins.versionCheck")
if not versionCheck.validModVersion("GlassHelper", "1.0.1")
  then return {}
end
reverse_booster.associatedMods = { "GlassHelper" }

reverse_booster.name = "GlassHelper/ReverseBooster"
reverse_booster.depth = -8580
reverse_booster.placements = {
    {
        name = "default",
        data = {
            red = false,
            twistSprite = "objects/revBooster/twist/twist"
        }
    },
    {
        name = "red",
        data = {
            red = true,
            twistSprite = "objects/revBooster/twist/twist"
        }
    }
}

function reverse_booster.sprite(room, entity)
    local sprites = {}

    local twistTexture = drawableSprite.fromTexture(entity.twistSprite .. "00", entity)

    local color = entity.red and "objects/booster/boosterRed00" or "objects/booster/booster00"
    local colorBooster = drawableSprite.fromTexture(color, entity)

    table.insert(sprites, twistTexture)
    table.insert(sprites, colorBooster)

    return sprites
end

function reverse_booster.selection(room, entity)
    local rect = utils.rectangle(entity.x - 16, entity.y - 16, 32, 32)

    return rect
end

reverse_booster.fieldOrder = {
    "x", "y",
    "red", "twistSprite"
}

return reverse_booster