local enums = require("consts.object_depths")
local contorthelper = require("mods").requireFromPlugin("libraries.ContortHelper.contorthelper")

local confetti = {}

confetti.associatedMods = { "ContortHelper" }

confetti.name = "ContortHelper/ConfettiSpawner"
confetti.depth = 0
confetti.texture = "ahorn/muntheory/contorthelper/confettispawner"
confetti.placements = {
    name = "default",
    data = {
        amount = 30,
        audio = "event:/game/07_summit/checkpoint_confetti",
        delaySpawnMaximum = 0.25,
        delaySpawnMinimum = 0.25,
        durationMaximum = 4.0,
        durationMinimum = 2.0,
        fallSpeedMaximum = 20.0,
        fallSpeedMinimum = 20.0,
        fallSpreadMaximum = 0.0,
        fallSpreadMinimum = 0.0,
        offsetXMaximum = 3.0,
        offsetXMinimum = -3.0,
        offsetYMaximum = 3.0,
        offsetYMinimum = -3.0,
        Rotation = 4.0,
        textures = "particles/confetti",
        depth = -10000,
        colors = "White"
    }
}

confetti.fieldInformation = {
    depth = {
        options = enums.depths,
        editable = true
    },
    colors = {
        allowXNAColors = true
    }
}

local confettiPath = {}

confettiPath.associatedMods = { "ContortHelper" }

confettiPath.name = "ContortHelper/ConfettiSpawnerPath"
confettiPath.depth = 0
confettiPath.texture = "ahorn/muntheory/contorthelper/confettispawnerpath"
confettiPath.placements = {
    name = "default",
    data = {
        amount = 30,
        audio = "event:/game/07_summit/checkpoint_confetti",
        delaySpawnMaximum = 0.25,
        delaySpawnMinimum = 0.25,
        durationMaximum = 4.0,
        durationMinimum = 2.0,
        fallSpeedMaximum = 20.0,
        fallSpeedMinimum = 20.0,
        fallSpreadMaximum = 0.0,
        fallSpreadMinimum = 0.0,
        offsetXMaximum = 3.0,
        offsetXMinimum = -3.0,
        offsetYMaximum = 3.0,
        offsetYMinimum = -3.0,
        Rotation = 4.0,
        textures = "particles/confetti",
        depth = -10000,
        colors = "White",
        moveEaser = "CubeInOut",
        pathSpeed = 1.181818
    }
}

confettiPath.fieldInformation = {
    depth = {
        options = enums.depths,
        editable = true
    },
    colors = {
        allowXNAColors = true
    },
    moveEaser = {
        options = contorthelper.easers,
        editable = false
    }
}

confettiPath.nodeLimits = {1, 1}
confettiPath.nodeLineRenderType = "line"

return {
    confetti,
    confettiPath
}
