local coroutineEntity = monocle.Entity()

local vector2 = require("#microsoft.xna.framework.vector2")

function onBegin(room)
  makeUnskippable()
  disableRetry()
  disableMovement()
  player.ForceCameraUpdate = false
  wait(0.35)
  walkTo(3051, false, 0.7, false)
  setFlag("abyssAngelDescend1", true)
  playSound("event:/game/06_reflection/scaryhair_whoosh", player.Position)
  wait(1.5)
  say("DonkMTC_abyssAngel1")
  wait(0.75)
  walkTo(3098, false, 0.5, false)
  setFlag("abyssAngelDescend2", true)
  playSound("event:/game/06_reflection/scaryhair_whoosh", player.Position)
  wait(1.3)
  walkTo(3072, false, 0.3, false)
  setFlag("abyssAngelDescend3", true)
  wait(0.5)
  player.DummyAutoAnimate = false
  player.Sprite:Play("lookUp", false)
  playSound("event:/game/06_reflection/hug_badeline_glow", player.Position)
  wait(1)
  coroutine.yield(getLevel():ZoomTo(vector2(158, 104), 1.6, 2))
  setFlag("abyssAngelWhiteFade", true)
  wait(3)
  getLevel():ResetZoom()
  setFlag("abyssAngelLevelUp", true)
  playSound("event:/game/06_reflection/hug_levelup_text_in", player.Position)
  wait(1)
  setFlag("abyssAngelBlock", true)
  enableMovement()
end

function onEnd(room, wasSkipped)
  enableMovement()
  player.DummyAutoAnimate = true
  player.ForceCameraUpdate = true
  getLevel():ResetZoom()
  enableMovement()
    if wasSkipped then
    player.DummyAutoAnimate = true
    player.ForceCameraUpdate = true
    getLevel():ResetZoom()
    enableMovement()
    end
end