﻿module AcidHelperTimeModulateTrigger

using ..Ahorn, Maple

@mapdef Trigger "AcidHelper/TimeModulateTrigger" TimeModulateTrigger(
	x::Integer, 
	y::Integer, 
	width::Integer=Maple.defaultTriggerWidth, 
	height::Integer=Maple.defaultTriggerHeight, 
	timeFrom::Number=1.0, 
	timeTo::Number=1.0, 
	positionMode::String="LeftToRight",
	completeAreaOnFrozen::Bool=false,
	destroyOnLeave::Bool=false,
	persistent::Bool=false
)

const placements = Ahorn.PlacementDict(
    "Time Modulate Trigger (Acid Helper)" => Ahorn.EntityPlacement(
        TimeModulateTrigger,
        "rectangle"
    )
)

Ahorn.editingOptions(entity::TimeModulateTrigger) = Dict{String, Any}(
    "positionMode" => Maple.trigger_position_modes
)

end
