﻿module AcidHelperTimeModulateTrigger

using ..Ahorn, Maple

@mapdef Trigger "AcidHelper/PatchedCameraTargetTrigger" PatchedCameraTargetTrigger(
	x::Integer, 
	y::Integer, 
	width::Integer=Maple.defaultTriggerWidth, 
	height::Integer=Maple.defaultTriggerHeight, 
	lerpStrength::Number=0.0,
	positionMode::String="NoEffect",
	xOnly::Bool=false,
	yOnly::Bool=false,
	nodes::Array{Tuple{Integer, Integer}, 1}=Tuple{Integer, Integer}[]
)

const placements = Ahorn.PlacementDict(
    "Patched Camera Target Trigger (Acid Helper)" => Ahorn.EntityPlacement(
       PatchedCameraTargetTrigger,
        "rectangle",
        Dict{String, Any}(),
        function(trigger)
            trigger.data["nodes"] = [(Int(trigger.data["x"]) + Int(trigger.data["width"]) + 8, Int(trigger.data["y"]))]
        end
    )
)

Ahorn.editingOptions(trigger::PatchedCameraTargetTrigger) = Dict{String, Any}(
    "positionMode" => Maple.trigger_position_modes
)

function Ahorn.nodeLimits(trigger::PatchedCameraTargetTrigger)
    return 1, 1
end

end
