﻿module AcidHelperAdvancedMusicLayerFadeTrigger

using ..Ahorn, Maple

@mapdef Trigger "AcidHelper/AdvancedMusicLayerFadeTrigger" AdvancedMusicLayerFadeTrigger(
	x::Integer, 
	y::Integer, 
	width::Integer=Maple.defaultTriggerWidth, 
	height::Integer=Maple.defaultTriggerHeight,
	trackEvent::String="",
	P1::String="",
	P1From::Number=1.0, 
	P1To::Number=1.0, 
	P1Direction::String="LeftToRight",
	P2::String="",
	P2From::Number=1.0, 
	P2To::Number=1.0, 
	P2Direction::String="LeftToRight",
	P3::String="",
	P3From::Number=1.0, 
	P3To::Number=1.0, 
	P3Direction::String="LeftToRight",
	persistent::Bool=false,
	destroyOnLeave::Bool=false,
)

const placements = Ahorn.PlacementDict(
    "Advanced Music Layer Fade Trigger (Acid Helper)" => Ahorn.EntityPlacement(
        AdvancedMusicLayerFadeTrigger,
        "rectangle"
    )
)

Ahorn.editingOptions(entity::AdvancedMusicLayerFadeTrigger) = Dict{String, Any}(
    "P1Direction" => Maple.trigger_position_modes,
	"P2Direction" => Maple.trigger_position_modes,
	"P3Direction" => Maple.trigger_position_modes
)

end
