﻿module AcidHelperSlippyWall

using ..Ahorn, Maple

@mapdef Entity "AcidHelper/SlippyWall" SlippyWall(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultBlockWidth,
	height::Integer=Maple.defaultBlockHeight,
	left::Bool=true
)

const placements = Ahorn.PlacementDict(
    "Slippy Wall (Right) (Shroom Helper)" => Ahorn.EntityPlacement(
        SlippyWall,
        "rectangle",
        Dict{String, Any}(
            "left" => true
        )
    ),
    "Slippy Wall (Left) (Shroom Helper)" => Ahorn.EntityPlacement(
        SlippyWall,
        "rectangle",
        Dict{String, Any}(
            "left" => false
        )
    )
)

Ahorn.minimumSize(entity::SlippyWall) = 0, 8
Ahorn.resizable(entity::SlippyWall) = false, true

function Ahorn.selection(entity::SlippyWall)
    x, y = Ahorn.position(entity)
    height = Int(get(entity.data, "height", 8))

    return Ahorn.Rectangle(x, y, 8, height)
end

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::SlippyWall, room::Maple.Room)
    left = get(entity.data, "left", false)

    # Values need to be system specific integer
    x = Int(get(entity.data, "x", 0))
    y = Int(get(entity.data, "y", 0))

    height = Int(get(entity.data, "height", 8))
    tileHeight = div(height, 8)

    if left
        for i in 2:tileHeight - 1
            Ahorn.drawImage(ctx, "objects/wallBooster/iceMid00", 0, (i - 1) * 8)
        end

        Ahorn.drawImage(ctx, "objects/wallBooster/iceTop00", 0, 0)
        Ahorn.drawImage(ctx, "objects/wallBooster/iceBottom00", 0, (tileHeight - 1) * 8)

    else
        Ahorn.Cairo.save(ctx)
        Ahorn.scale(ctx, -1, 1)

        for i in 2:tileHeight - 1
            Ahorn.drawImage(ctx, "objects/wallBooster/iceMid00", -8, (i - 1) * 8)
        end

        Ahorn.drawImage(ctx, "objects/wallBooster/iceTop00", -8, 0)
        Ahorn.drawImage(ctx, "objects/wallBooster/iceBottom00", -8, (tileHeight - 1) * 8)

        Ahorn.restore(ctx)
    end
end

end