﻿module AcidHelperSibBlockerSwitch

using ..Ahorn, Maple

@mapdef Entity "AcidHelper/SibBlockerSwitch" SibBlockerSwitch(x::Integer, y::Integer, 
    flag::String="sib_switch", icon::String="vanilla", persistent::Bool=false, inactiveColor::String="5FCDE4", activeColor::String="FFFFFF", finishColor::String="F141DF")

const bundledIcons = String["1", "2", "3", "4"]

const placements = Ahorn.PlacementDict(
    "Sib Blocker Switch (Acid Helper)" => Ahorn.EntityPlacement(
        SibBlockerSwitch
    )
)

Ahorn.editingOptions(entity::SibBlockerSwitch) = Dict{String,Any}(
    "icon" => bundledIcons
)

function Ahorn.selection(entity::SibBlockerSwitch)
    x, y = Ahorn.position(entity)

    return  Ahorn.Rectangle(x - 7, y - 7, 14, 14)
end

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::SibBlockerSwitch, room::Maple.Room)
    Ahorn.drawSprite(ctx, "objects/sibBlockerSwitch/container.png", 0, 0)

    icon = get(entity.data, "icon", "vanilla")
    
    iconPath = "objects/touchswitch/icon00.png"
    if icon != "vanilla"
        iconPath = "objects/sibBlockerSwitch/$(icon)/icon00.png"
    end

    Ahorn.drawSprite(ctx, iconPath, 0, 0)
end

end
