﻿module AcidHelperSecretInputUnlock

using ..Ahorn, Maple

@mapdef Entity "AcidHelper/SecretInputUnlock" SecretInputUnlock(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultBlockWidth,
	height::Integer=Maple.defaultBlockHeight,
	nodes::Array{Tuple{Integer, Integer}, 1}=Tuple{Integer, Integer}[]
)

function satelliteFinalizer(entity::SecretInputUnlock)
    x, y = Ahorn.position(entity)

    entity.data["nodes"] = [
        (x + 64, y),
        (x + 48, y),
    ]
end

const placements = Ahorn.PlacementDict(
    "Secret Heart Unlock (Acid Helper)" => Ahorn.EntityPlacement(
        SecretInputUnlock,
        "point",
        Dict{String, Any}(),
        satelliteFinalizer
    )
)

Ahorn.nodeLimits(entity::SecretInputUnlock) = 2, 2

birdSprite = "scenery/flutterbird/idle00.png"
gemSprite = "collectables/heartGem/0/00.png"

dishSprite = "objects/citysatellite/dish.png"
lightSprite = "objects/citysatellite/light.png"
computerSprite = "objects/citysatellite/computer.png"
computerScreenSprite = "objects/citysatellite/computerscreen.png"

# Offsets from game
computerOffsetX = 32
computerOffsetY = 24

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::SecretInputUnlock)
    x, y = Ahorn.position(entity)

    nodes = get(entity.data, "nodes", ((x, y), (x, y)))
    birdX, birdY = nodes[1]
    gemX, gemY = nodes[2]

    Ahorn.drawSprite(ctx, gemSprite, gemX, gemY)
    Ahorn.drawSprite(ctx, birdSprite, birdX, birdY, jx=0.5, jy=1.0)

    for node in nodes
        nx, ny = Int.(node)

        Ahorn.drawArrow(ctx, x, y, nx, ny, Ahorn.colors.selection_selected_fc, headLength=6)
    end
end

function Ahorn.selection(entity::SecretInputUnlock)
    x, y = Ahorn.position(entity)

    nodes = get(entity.data, "nodes", ((x, y), (x, y)))
    birdX, birdY = nodes[1]
    gemX, gemY = nodes[2]

    return [
        Ahorn.coverRectangles([
            Ahorn.getSpriteRectangle(gemSprite, x, y),
        ]),
        Ahorn.getSpriteRectangle(birdSprite, birdX, birdY, jx=0.5, jy=1.0),
        Ahorn.getSpriteRectangle(gemSprite, gemX, gemY)
    ]
end

function Ahorn.renderAbs(ctx::Ahorn.Cairo.CairoContext, entity::SecretInputUnlock, room::Maple.Room)
    x, y = Ahorn.position(entity)
    Ahorn.drawSprite(ctx, gemSprite, x, y)
end

end
