﻿  
module AcidHelperPureKillBox

using ..Ahorn, Maple

@mapdef Entity "AcidHelper/PureKillBox" PureKillBox(x::Integer, y::Integer, width::Integer=Maple.defaultBlockWidth, height::Integer=Maple.defaultBlockHeight)

const placements = Ahorn.PlacementDict(
    "Pure Killbox (Acid Helper)" => Ahorn.EntityPlacement(
        PureKillBox,
        "rectangle"
    ),
)

Ahorn.minimumSize(entity::PureKillBox) = 8, 8
Ahorn.resizable(entity::PureKillBox) = true, true

function Ahorn.selection(entity::PureKillBox)
    x, y = Ahorn.position(entity)

    width = Int(get(entity.data, "width", 8))
    height = Int(get(entity.data, "height", 8))

    return Ahorn.Rectangle(x, y, width, height)
end

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::PureKillBox, room::Maple.Room)
    width = Int(get(entity.data, "width", 32))
    height = Int(get(entity.data, "height", 32))

    Ahorn.drawRectangle(ctx, 0, 0, width, height, (0.8, 0.4, 0.4, 0.8), (0.0, 0.0, 0.0, 0.0))
end

end