﻿module AcidHelperParticleSource

using ..Ahorn, Maple

@mapdef Entity "AcidHelper/ParticleSource" ParticleSource(x::Integer, y::Integer, amount::Integer=1, radius::Number=8.0, rate::Number=0.1, color::String="red")

const colors = ["red", "blue", "gold", "pink"]

const placements = Ahorn.PlacementDict(
	"Particle Source (Acid Helper)" => Ahorn.EntityPlacement(
		ParticleSource
	)
)

Ahorn.editingOptions(entity::ParticleSource) = Dict{String,Any}(
	"color" => colors
)

function Ahorn.selection(entity::ParticleSource)
	x, y = Ahorn.position(entity)

	return Ahorn.Rectangle(x - 4, y - 4, 7, 8)
end

function Ahorn.renderAbs(ctx::Ahorn.Cairo.CairoContext, entity::ParticleSource, room::Maple.Room)
	x, y = Ahorn.position(entity)
	sprite = Ahorn.getTextureSprite("objects/hanginglamp", "Gameplay")
	
	Ahorn.drawImage(ctx, sprite, x - 4, y - 4, 0, 16, 7, 8, alpha=0.7)
end

end