﻿module AcidHelperLightSource

using ..Ahorn, Maple

@mapdef Entity "AcidHelper/LightSource" LightSource(x::Integer, y::Integer, fromColor::String="FFFFFF", toColor::String="FF4500", colorFadeAlpha::Number=0.5, startFade::Integer=48, endFade::Integer=64, alpha::Number=1.0)

const placements = Ahorn.PlacementDict(
	"Light Source (Acid Helper)" => Ahorn.EntityPlacement(
		LightSource
	)
)

function Ahorn.selection(entity::LightSource)
	x, y = Ahorn.position(entity)

	return Ahorn.Rectangle(x - 4, y - 4, 7, 8)
end

function Ahorn.renderAbs(ctx::Ahorn.Cairo.CairoContext, entity::LightSource, room::Maple.Room)
	x, y = Ahorn.position(entity)
	sprite = Ahorn.getTextureSprite("objects/hanginglamp", "Gameplay")
	
	Ahorn.drawImage(ctx, sprite, x - 4, y - 4, 0, 16, 7, 8, alpha=0.7)
end

end