﻿module AcidHelperInstantTeleporter

using ..Ahorn, Maple

@mapdef Entity "AcidHelper/InstantTeleporter" InstantTeleporter(
	x::Integer, 
	y::Integer, 
	width::Integer=Maple.defaultBlockWidth, 
	height::Integer=Maple.defaultBlockHeight, 
	trueColorHex::String="0000ff", 
	targetRoomId::String="",
	goldenWarp::Bool=false,
	currentLevelGoldenWarp::Bool=false,
	respawn::Bool=false,
	glitched::Bool=true, 
	opacity::Number=1.0,
	isCollidable::Bool=false,
	rippleAreaMultiplier::Number=1.0,
	respawnPositionX::Integer=0,
	respawnPositionY::Integer=0
)

const placements = Ahorn.PlacementDict(
    "Instant Teleporter (Acid Helper)" => Ahorn.EntityPlacement(
        InstantTeleporter,
        "rectangle",
		Dict{String, Any}(),
        function(entity)
			entity.data["trueColorHex"] = "0000ff"
        end
    ),
)

Ahorn.minimumSize(entity::InstantTeleporter) = 8, 8
Ahorn.resizable(entity::InstantTeleporter) = true, true

function Ahorn.selection(entity::InstantTeleporter)
    x, y = Ahorn.position(entity)

    width = Int(get(entity.data, "width", 8))
    height = Int(get(entity.data, "height", 8))

    return Ahorn.Rectangle(x, y, width, height)
end

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::InstantTeleporter, room::Maple.Room)
    width = Int(get(entity.data, "width", 32))
    height = Int(get(entity.data, "height", 32))
    
	rawColor = Ahorn.argb32ToRGBATuple(parse(Int, get(entity.data, "trueColorHex", "0000ff"), base=16))[1:3] ./ 255
    realColor = (rawColor..., 0.8)

    Ahorn.drawRectangle(ctx, 0, 0, width, height, realColor, (0.0, 0.0, 0.0, 0.0))
end

end