﻿module AcidHelperDoubleBooster

using ..Ahorn, Maple

@mapdef Entity "AcidHelper/DoubleBooster" DoubleBooster(x::Integer, y::Integer)

const placements = Ahorn.PlacementDict(
    "Double Booster (Acid Helper)" => Ahorn.EntityPlacement(
        DoubleBooster
    )
)

function boosterSprite(entity::DoubleBooster)
	return "objects/glyphbooster/boosterPink00"
end

function Ahorn.selection(entity::DoubleBooster)
    x, y = Ahorn.position(entity)
    sprite = boosterSprite(entity)
    return Ahorn.getSpriteRectangle(sprite, x, y)
end

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::DoubleBooster, room::Maple.Room)
    sprite = boosterSprite(entity)
    Ahorn.drawSprite(ctx, sprite, 0, 0)
end

end