﻿module AcidHelperCrumbleWallOnTouch

using ..Ahorn, Maple

@mapdef Entity "AcidHelper/CrumbleWallOnTouch" CrumbleWallOnTouch(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultBlockWidth,
	height::Integer=Maple.defaultBlockHeight,
	blendin::Bool=true,
	persistent::Bool=false,
	delay::Number=0.0
)

const placements = Ahorn.PlacementDict(
    "Crumble Wall On Touch (Acid Helper)" => Ahorn.EntityPlacement(
        CrumbleWallOnTouch,
        "rectangle",
        Dict{String, Any}(),
        Ahorn.tileEntityFinalizer
    )
)

Ahorn.editingOptions(entity::CrumbleWallOnTouch) = Dict{String, Any}(
    "tiletype" => Ahorn.tiletypeEditingOptions()
)

Ahorn.minimumSize(entity::CrumbleWallOnTouch) = 8, 8
Ahorn.resizable(entity::CrumbleWallOnTouch) = true, true

Ahorn.selection(entity::CrumbleWallOnTouch) = Ahorn.getEntityRectangle(entity)

Ahorn.renderAbs(ctx::Ahorn.Cairo.CairoContext, entity::CrumbleWallOnTouch, room::Maple.Room) = Ahorn.drawTileEntity(ctx, room, entity)

end