﻿namespace Celeste.Mod.RussianFix
{
    public class RussianFixModule : EverestModule
    {
        public static RussianFixModule Instance { get; private set; }

        public RussianFixModule()
        {
            Instance = this;
        }

        public override void Load()
        {
            On.Celeste.Dialog.MergeLanguages += OnMerge;
        }

        public override void Unload()
        {
            On.Celeste.Dialog.MergeLanguages -= OnMerge;
        }

        public static Language OnMerge(On.Celeste.Dialog.orig_MergeLanguages orig, Language orig_lang, Language mod_lang)
        {
            Language lang = orig(orig_lang, mod_lang);

            // Make Merge do what it supposed to
            if (lang.Id == "russian" && mod_lang != null)
            {
                lang.FontFace = mod_lang.FontFace;
                lang.FontFaceSize = mod_lang.FontFaceSize;
                lang.IconPath = mod_lang.IconPath;
                lang.Icon = mod_lang.Icon;
                lang.Order = mod_lang.Order;
            }
            return lang;
        }
    }
}