local utils = require("utils")

local heatController = {}

heatController.name = "HeatMeter/HeatController"
heatController.depth = 2000
heatController.placements = {
    name = "Heat Controller",
    data = {
        HeatIncreasePerSecond = 10,
        HeatDecreasePerSecond = 10,
        HeatStopsBehindBackground = true,
        HeatDecreasesInWater = true
    }
}

heatController.fieldInformation = {
    HeatIncreasePerSecond = {
        fieldType = "integer",
        minimumValue = 0,
        maximumValue = 100,

    },
    HeatDecreasePerSecond = {
        fieldType = "integer",
        minimumValue = 0,
        maximumValue = 100,

    }
}
heatController.texture = "objects/HeatMeter/HeatController/00"
heatController.justification = {0.5, 0.5}


function heatController.selection(room, entity)
    local x, y = entity.x or 0, entity.y or 0
    return utils.rectangle(x - 8, y - 8, 16, 16)
end

return heatController