﻿using Celeste.Mod.Entities;
using Microsoft.Xna.Framework;
using Monocle;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using MonoMod.Utils;
using MonoMod.Cil;
using Mono.Cecil.Cil;

namespace Celeste.Mod.ScuffedHelper {

    [CustomEntity("ScuffedHelper/WaterBerry")]
    [Tracked]
    [TrackedAs(typeof(Strawberry))]
    class WaterBerry : Strawberry {
        public static Sprite waterBerrySprite;
        public static SpriteBank waterBerrySpriteBank;

        public bool IsWater {
            get;
            private set;
        }

        public WaterBerry(EntityData data, Vector2 offset, EntityID gid) : base(data, offset, gid) {
            //do things?
            IsWater = true;
        }

        public static void Load() {
            IL.Celeste.Strawberry.Added += modAdded;
            
        }

        public static void Unload() {
            IL.Celeste.Strawberry.Added -= modAdded;
        }

        public override void Added(Scene scene) {
            waterBerrySpriteBank = new SpriteBank(GFX.Game, "Graphics/Xmls/WaterBerry.xml");
            waterBerrySprite = waterBerrySpriteBank.Create("WaterBerry");

            base.Added(scene);

        }

        const int pixelCount = 5;
        const int colourRange = 10;
        private int count = 5;
        public override void Update() {
            base.Update();

            //make particles
            //could be precalculated but eh
            if (count == pixelCount) {


                Rectangle playerCollider = Collider.Bounds;

                //playerCollider.Offset((int)self.X, (int)self.Y);
                Random r = new Random();

                const int shrink = 4;

                Vector2 randomPos = new Vector2(
                    r.Next((int)playerCollider.Left + shrink, (int)playerCollider.Right - shrink + 1),
                    r.Next((int)playerCollider.Top + shrink, (int)playerCollider.Bottom - shrink));

                Color particleColor = new Color(Color.LightSkyBlue.ToVector3() + new Vector3(
                        r.Next(-colourRange, colourRange) / 255,
                        r.Next(-colourRange, colourRange) / 255,
                        r.Next(-colourRange, colourRange) / 255));
                //new WaterDashParticle(randomPos, particleColor, (float)Math.Sqrt(r.NextDouble()));

                Level level = Scene as Level;

                //maybe use texture to get more "streaky" look?
                ParticleType type = new ParticleType();
                type.Color = particleColor;
                type.Color2 = Color.Transparent;
                type.ColorMode = ParticleType.ColorModes.Fade;
                type.LifeMin = 0.3f;
                type.LifeMax = 0.5f;
                type.SpeedMin = -20;
                type.SpeedMax = -30;
                type.Size = 1;

                float rotation = 3f * (float)Math.PI / 2f;

                //type.FadeMode = 1;
                level.ParticlesFG.Emit(type, randomPos, rotation);

                count = 0;
            }
            count++;
        }


        public override void Render() {
            base.Render();

            

            if (SetWaterDashesEntity.hasTouchedWater) {
                Scene.Remove(this);
            }
            
        }

        private static void modAdded(ILContext il) {

            ILCursor cursor = new ILCursor(il);

            while (cursor.TryGotoNext(MoveType.After, instr => instr.MatchLdstr("strawberry") || instr.MatchLdstr("ghostberry"))) {

                //https://discordapp.com/channels/403698615446536203/514006912115802113/827690901395603486
                cursor.TryGotoNext(MoveType.After, instr => instr.MatchCallvirt<SpriteBank>("Create"));

                //https://discordapp.com/channels/403698615446536203/514006912115802113/827669521866555444
                //from coloursofnoise (who is an amazing person)
                //basically, put the cursor directly after where that string is loaded, 
                //then emit a method that takes in that string and returns a new one that may (or may not) be different

                //this changes all strawberries to waterberrysprite
                //so I need to find some condition that would make only waterberries change sprite
                //ideally I should know what strawberry is being added

                //gets object
                // NOTE: in update, this code yells at me for using lambdas
                cursor.Emit(OpCodes.Ldarg_0);
                Object thisObject = null;
                cursor.EmitDelegate<Func<Object, Object>>(o =>
                {
                    thisObject = o;
                    return o;
                });
                cursor.Emit(OpCodes.Pop);
                cursor.EmitDelegate<Func<Sprite, Sprite>>(s =>
                {

                    if (thisObject.GetType() == typeof(WaterBerry)) {
                        return waterBerrySprite;
                    }
                    return s;
                });
            }
        }

        
        
    }
}
