﻿using Celeste.Mod.Entities;
using Microsoft.Xna.Framework;
using Monocle;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using static On.Celeste.Player;

namespace Celeste.Mod.ScuffedHelper {
    class WaterDashParticle {
        public static List<WaterDashParticle> waterDashParticles = new List<WaterDashParticle>();
        public const float particleFade = 0.02f;
        public const float particleVariation = particleFade / 3;

        private Vector2 pos;
        private float opacity;
        private Color color;

        private float thisParticleFade;

        private bool duplicate;
        public WaterDashParticle(Vector2 pos, Color color, float opacity = 1, bool duplicate = true) {
            this.opacity = opacity;
            this.pos = pos;
            this.color = color;
            this.duplicate = duplicate;

            thisParticleFade = (float) new Random().NextDouble() * particleFade + particleVariation;

            waterDashParticles.Add(this);
        }

        public void Render() {
            //Draw.Pixel.Draw(pos, Vector2.Zero, new Color(color, opacity));
            Draw.Pixel.Draw(pos, Vector2.Zero, new Color(255, 128, 255, 0.5f));
            opacity -= particleFade;

            if(opacity <= 0) {
                waterDashParticles.Remove(this);
            }

            //Logger.Log("Height Contest", $"Rendering particle, {pos}, {color * opacity}");

            //Logger.Log("WaterDashParticle", $"Rendering");

            if (opacity > 0 && duplicate) {
                new WaterDashParticle(pos, color, opacity - thisParticleFade, false);
            }

            pos += Vector2.UnitY;

        }
    }

    [CustomEntity("ScuffedHelper/SetWaterDashesEntity")]
    [Tracked]
    class SetWaterDashesEntity : Entity {

        //sure just set everything to static
        public static int numDashes;
        public static bool persistent;
        public static bool enabled;
        public static bool isWaterDash;

        public static string hairColour;

        //for toggling berry
        public static bool hasTouchedWater;

        public SetWaterDashesEntity(EntityData data, Vector2 offset) : base(data.Position + offset) {
            numDashes = data.Int("waterDashes", 3);
            persistent = data.Bool("isPersistent", false);
            enabled = data.Bool("isEnabled", false);

            hairColour = data.Attr("waterDashHairColour", "#0000FF");
        }

        #region Hooks
        // Hook initialization

        public static void Load() {
            On.Celeste.Player.SwimUnderwaterCheck += modSwimUnderwaterCheck;
            On.Celeste.Player.DashUpdate += modDashUpdate;
            On.Celeste.Player.DashEnd += modDashEnd;
            On.Celeste.Player.Render += modRender;
            On.Celeste.Player.Die += modDie;
            On.Celeste.Level.LoadLevel += modLoadLevel;
        }

        // Unload the entirety of your mod's content. Free up any native resources.
        public static void Unload() {
            On.Celeste.Player.SwimUnderwaterCheck -= modSwimUnderwaterCheck;
            On.Celeste.Player.DashUpdate -= modDashUpdate;
            On.Celeste.Player.DashEnd -= modDashEnd;
            On.Celeste.Player.Render -= modRender;
            On.Celeste.Player.Die -= modDie;
            On.Celeste.Level.LoadLevel -= modLoadLevel;
        }

        

        private static bool modSwimUnderwaterCheck(orig_SwimUnderwaterCheck orig, global::Celeste.Player self) {

            //check if there are no entities in the scene
            //because otherwise this entity pernamently gives you dashes in water
            try {
                if (self.Scene.Tracker.GetEntities<SetWaterDashesEntity>().Count == 0) {
                    enabled = false;
                }
            }catch(KeyNotFoundException e) {
                enabled = false;
            }

            if (enabled) {
                self.Dashes = numDashes;
                
                isWaterDash = true;

                hasTouchedWater = true;
            }



            return orig(self);
        }

        private static void modRender(orig_Render orig, global::Celeste.Player self) {

            //set hair colour
            if(isWaterDash) {
                self.Hair.Color = HexToColor(hairColour);
            }

            //draw particles
            List<WaterDashParticle> currParticles = new List<WaterDashParticle>(WaterDashParticle.waterDashParticles);
            foreach (WaterDashParticle p in currParticles) {
                p.Render();
            }

            orig(self);
        }

        const int pixelCount = 5;
        const int colourRange = 10;
        private static int modDashUpdate(orig_DashUpdate orig, global::Celeste.Player self){

            if (isWaterDash) {
                //draw pixels that fall down and fade out
                for(int i=0; i<pixelCount; i++) {
                    Rectangle playerCollider = self.Collider.Bounds;
                    //playerCollider.Offset((int)self.X, (int)self.Y);
                    Random r = new Random();

                    Vector2 randomPos = new Vector2(
                        r.Next((int) playerCollider.Left, (int) playerCollider.Right),
                        r.Next((int) playerCollider.Top, (int) playerCollider.Bottom));

                    Color particleColor = new Color(Color.LightSkyBlue.ToVector3() + new Vector3(
                            r.Next(-colourRange, colourRange)/255,
                            r.Next(-colourRange, colourRange)/255,
                            r.Next(-colourRange, colourRange)/255));
                    //new WaterDashParticle(randomPos, particleColor, (float)Math.Sqrt(r.NextDouble()));

                    //Logger.Log("Height Contest", $"{particleColor}");

                    Level level = self.Scene as Level;

                    //maybe use texture to get more "streaky" look?
                    ParticleType type = new ParticleType();
                    type.Color = particleColor;
                    type.Color2 = Color.Transparent;
                    type.ColorMode = ParticleType.ColorModes.Fade;
                    type.LifeMin = 1;
                    type.LifeMax = 1.5f;
                    type.SpeedMin = -30;
                    type.SpeedMax = -50;
                    type.Size = 1;
                    //type.FadeMode = 1;
                    level.ParticlesFG.Emit(type, self.Center + Calc.Random.Range(Vector2.One * -4f, Vector2.One * 4f), 3f*(float) Math.PI/2f);
                }

                



            }


            return orig(self);
        }

        private static void modDashEnd(orig_DashEnd orig, global::Celeste.Player self) {
            orig(self);
            if (self.Dashes != numDashes) {
                isWaterDash = false;
            }
        }

        private static void modLoadLevel(On.Celeste.Level.orig_LoadLevel orig, global::Celeste.Level self, global::Celeste.Player.IntroTypes playerIntro, bool isFromLoader) {
            orig(self, playerIntro, isFromLoader);

            if (isFromLoader) {
                hasTouchedWater = false;
                isWaterDash = false;
            }
            
        }

        private static PlayerDeadBody modDie(orig_Die orig, Player self, Vector2 direction, bool evenIfInvincible, bool registerDeathInStats) {
            isWaterDash = false;
            return orig(self, direction, evenIfInvincible, registerDeathInStats);
        }

        #endregion

        //from https://www.devx.com/tips/dot-net/c-sharp/convert-hex-to-rgb-190527095529.html
        public static Color HexToColor(string hexString) {
            //replace # occurences
            if (hexString.IndexOf('#') != -1)
                hexString = hexString.Replace("#", "");

            int r, g, b = 0;

            r = int.Parse(hexString.Substring(0, 2), NumberStyles.AllowHexSpecifier);
            g = int.Parse(hexString.Substring(2, 2), NumberStyles.AllowHexSpecifier);
            b = int.Parse(hexString.Substring(4, 2), NumberStyles.AllowHexSpecifier);

            return new Color(r, g, b);
        }
    }
}
