﻿using Celeste.Mod.ScuffedHelper;
using ScuffedHelperCode;
using System;

namespace Celeste.Mod.ScuffedHelper;

public class ScuffedHelperModule : EverestModule {
    public static ScuffedHelperModule Instance { get; private set; }

    public override Type SettingsType => typeof(ScuffedHelperModuleSettings);
    public static ScuffedHelperModuleSettings Settings => (ScuffedHelperModuleSettings) Instance._Settings;

    public override Type SessionType => typeof(ScuffedHelperModuleSession);
    public static ScuffedHelperModuleSession Session => (ScuffedHelperModuleSession) Instance._Session;

    public override Type SaveDataType => typeof(ScuffedHelperModuleSaveData);
    public static ScuffedHelperModuleSaveData SaveData => (ScuffedHelperModuleSaveData) Instance._SaveData;

    public ScuffedHelperModule() {
        Instance = this;
#if DEBUG
        // debug builds use verbose logging
        Logger.SetLogLevel(nameof(ScuffedHelperModule), LogLevel.Verbose);
#else
        // release builds use info logging to reduce spam in log files
        Logger.SetLogLevel(nameof(ScuffedHelperModule), LogLevel.Info);
#endif
    }

    public override void Load() {
        SetWaterDashesEntity.Load();
        WaterBerry.Load();
        MovableRespawn.Load();
        FourSurfaceWater.Load();
        RandomSpinner.Load();

        On.Celeste.Level.LoadLevel += Mod_LoadLevel;
        On.Celeste.Player.Die += MovableRespawn.Mod_PlayerDie;
        On.Celeste.Water.Ray.Reset += FourSurfaceWater.CustomSurface.Mod_RayReset;
    }

    public override void Unload() {
        SetWaterDashesEntity.Unload();
        WaterBerry.Unload();
        MovableRespawn.Unload();
        FourSurfaceWater.Unload();
        RandomSpinner.Unload();

        On.Celeste.Level.LoadLevel -= Mod_LoadLevel;
        //On.Celeste.Player.Die -= MovableRespawn.Mod_PlayerDie;
        On.Celeste.Water.Ray.Reset -= FourSurfaceWater.CustomSurface.Mod_RayReset;

    }

    // Note: I do not know what this code is for
    public static DateTime LastLoadTime = new DateTime();
    private void Mod_LoadLevel(On.Celeste.Level.orig_LoadLevel orig, Level self, Player.IntroTypes playerIntro, bool isFromLoader)
    {
        orig(self, playerIntro, isFromLoader);
        LastLoadTime = DateTime.Now;

    }
}