﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Celeste;
using Celeste.Mod;
using Celeste.Mod.Entities;
using Celeste.Mod.ScuffedHelper;
using Microsoft.Xna.Framework;
using Monocle;

namespace ScuffedHelperCode {
    [CustomEntity("ScuffedHelper/RandomSpinner")]
    [Tracked]
    class RandomSpinner : CrystalStaticSpinner{

        private static Random thisRandom = new Random();
        private int Max;

        public static void Load() {
            On.Celeste.Level.LoadLevel += Level_LoadLevel;
        }
        

        public static void Unload() {
            On.Celeste.Level.LoadLevel -= Level_LoadLevel;
        }

        public RandomSpinner(EntityData data, Vector2 offset, EntityID gid) : base(data, offset, CrystalColor.Rainbow) {
            Max = data.Int("chance", 1);
            
        }

        private static void Level_LoadLevel(On.Celeste.Level.orig_LoadLevel orig, Level self, Player.IntroTypes playerIntro, bool isFromLoader) {
            orig(self, playerIntro, isFromLoader);
            foreach (RandomSpinner rs in self.Tracker.GetEntities<RandomSpinner>()) {
                if (thisRandom.Next(0, rs.Max) < 1) {
                    rs.RemoveSelf();
                    //Logger.Log("Scuffed Helper", $"Removed self");
                }
            };
        }


    }
}
