﻿using Celeste.Mod.Entities;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Monocle;
using MonoMod.Cil;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using static Celeste.Level;

namespace Celeste.Mod.ScuffedHelper{

    [CustomEntity("ScuffedHelper/MovableRespawn")]
    [Tracked]
    class MovableRespawn : Entity {

        private MTexture texture;

        private Vector2 imageOffset;

        private bool flipped;

        public MovableRespawn(EntityData data, Vector2 offset, EntityID id) : base(data.Position + offset) {
            texture = GFX.Game["characters/player/sleep00"];
            //background tiles have a depth of 10000
            Depth = 9999;

            flipped = data.Bool("flipped", false);

            //make marker flippable
            Collider = new Hitbox(13, 17, -7, -1);

            //from Spike code
            Add(new StaticMover {
                OnShake = OnShake,
                SolidChecker = IsRiding,
                JumpThruChecker = IsRiding
            });
        }

        #region hooks
        //maybe too complex
        //nvm, this was far easier than it should have been
        //I cannot believe how easy this was

        public static void Load() {
            //IL.Celeste.PlayerDeadBody.End += modDeathEnd;
            On.Celeste.Player.Die += modPlayerDie;
        }

        

        public static void Unload() {
            //IL.Celeste.PlayerDeadBody.End -= modDeathEnd;
            On.Celeste.Player.Die -= modPlayerDie;
        }

        private static PlayerDeadBody modPlayerDie(On.Celeste.Player.orig_Die orig, Player self, Vector2 direction, bool evenIfInvincible, bool registerDeathInStats) {
            Level level = self.Scene as Level;
            //Logger.Log("Scuffed Helper", $"{level.RetryPlayerCorpse}");

            int[] test = { 1, 2, 3 };
            
            test.Sum();

            PlayerDeadBody pdb = orig(self, direction, evenIfInvincible, registerDeathInStats);

            //if retried from menu
            //doesn't work, since level.RetryPlayerCorpse is only set to something after all of this
            //would need to put in respawnPlayer
            /*
            if(level.RetryPlayerCorpse != null) {
                return pdb;
            }
            */

            MovableRespawn movableRespawn = level.Tracker.GetEntity<MovableRespawn>();

            if (movableRespawn != null && pdb != null) {
                //could be null
                pdb.DeathAction = movableRespawn.RespawnPlayer;

            }
            
            return pdb;
        }

        private static MethodInfo levelLoadNewPlayer = typeof(Level).GetMethod("LoadNewPlayer", BindingFlags.Static | BindingFlags.NonPublic);

        public void RespawnPlayer() {
            Level level = Scene as Level;
            if(level.RetryPlayerCorpse != null) {
                level.Reload();
                return;
            }
            //copied from level.load()
            PlayerSpriteMode spriteMode = ((!level.Session.Inventory.Backpack) ? PlayerSpriteMode.MadelineNoBackpack : PlayerSpriteMode.Madeline);
            Player player = (Player) levelLoadNewPlayer.Invoke(this, new Object[] { Position + new Vector2(1, 16), spriteMode });
            player.IntroType = Player.IntroTypes.Respawn;
            Scene.Add(player);

            //camera
            /*
            CameraLockModes cameraLockMode = level.CameraLockMode;
            level.CameraLockMode = CameraLockModes.None;
                //throws error, because player does not have a cameraTarget
            level.Camera.Position = level.GetFullCameraTargetAt(player, player.Position);
            level.CameraLockMode = cameraLockMode;
            level.CameraUpwardMaxY = level.Camera.Y + 180f;
            */

            level.DoScreenWipe(wipeIn: true);

            
        }

        public static void modDeathEnd(ILContext il) {
            ILCursor cursor = new ILCursor(il);

            while (cursor.TryGotoNext(MoveType.After, instr => instr.MatchLdftn(typeof(Level), "Reload"))) {
                Level level = Engine.Scene as Level;
                level.Update();

            }
        }

        #endregion

        private void OnShake(Vector2 amount) {
            //when is this called?
            //eh
            imageOffset += amount;
        }

        private bool IsRiding(Solid solid) {
            return CollideCheckOutside(solid, Position + Vector2.UnitY);
        }

        private bool IsRiding(JumpThru jumpThru) {
            return CollideCheck(jumpThru, Position + Vector2.UnitY);
        }

        public override void Update() {
            base.Update();
        }

        public override void Render() {
            //render sprite
            Vector2 position = Position;
            Position += imageOffset;
            texture.DrawCentered(Position + Vector2.UnitX, new Color(1, 1, 1, 0.3f), 1, 0, flipped ? SpriteEffects.FlipHorizontally : SpriteEffects.None);
            base.Render();
            Position = position;
        }

        public static PlayerDeadBody Mod_PlayerDie(On.Celeste.Player.orig_Die orig, Player self, Vector2 direction, bool evenIfInvincible, bool registerDeathInStats) {

            return orig(self, direction, evenIfInvincible, registerDeathInStats);
        }
    }
}
