﻿using Celeste.Mod.Entities;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Mono.Cecil.Cil;
using Monocle;
using MonoMod.Cil;
using MonoMod.Utils;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using static Celeste.GaussianBlur;

namespace Celeste.Mod.ScuffedHelper {

    [CustomEntity("ScuffedHelper/FourSurfaceWater")]
    [TrackedAs(typeof(Water))]
    public class FourSurfaceWater : Water {

        //TODO: fix eeveehelper movement
            //the reason this is happening is that the surfaces are drawn at the time, with gfx.draw (presumably)

        private const string origFill = "87cefa4d";
        private const string origSurface = "87cefacc";
        private const string origRay = "87cefa99";

        private static FieldInfo fillColorField = typeof(Water).GetField("FillColor", BindingFlags.Static | BindingFlags.Public);

        private static FieldInfo surfaceColorField = typeof(Water).GetField("SurfaceColor", BindingFlags.Static | BindingFlags.Public);

        private static FieldInfo rayTopColorField = typeof(Water).GetField("RayTopColor", BindingFlags.Static | BindingFlags.Public);

        private bool raysContained = false;

        public static void Load() {
            CustomSurface.Load();
            On.Celeste.Water.RenderDisplacement += Water_RenderDisplacement;
            //sides are wierd because of displacement renderer
        }

        private static void Water_RenderDisplacement(On.Celeste.Water.orig_RenderDisplacement orig, Water self) {
            if(!(self is FourSurfaceWater)) {
                orig(self);
            }
        }

        public static void Unload() {
            CustomSurface.Unload();
            On.Celeste.Water.RenderDisplacement -= Water_RenderDisplacement;
        }

        public class CustomSurface : Surface {

            private Vector2 Offset;
            private FourSurfaceWater Parent;

            private Color ThisSurfaceColour;
            private List<Color> ThisRayColours;
            private Color ThisFillColour;
            private float ThisRaysPerPixel;

            private float RayLengthLow;
            private float RayLengthHigh;

            #region Hooks
            public static void Load() {
                IL.Celeste.Water.Surface.Update += WaterSurface_Update;
                On.Celeste.Water.Surface.Update += Surface_Update;
            }

            private static void Surface_Update(On.Celeste.Water.Surface.orig_Update orig, Surface self) {
                // set colour
                orig(self);
                if(self is CustomSurface) {
                    (self as CustomSurface).FixMesh();
                }
            }

            public static void Unload() {
                IL.Celeste.Water.Surface.Update -= WaterSurface_Update;
                On.Celeste.Water.Surface.Update -= Surface_Update;
            }

            private static void WaterSurface_Update(ILContext il) {
                ILCursor cursor = new ILCursor(il);


                while (cursor.TryGotoNext(MoveType.After, instr => instr.MatchLdsfld(rayTopColorField))) {
                    //this can most likely be simplified

                    //gets object
                    cursor.Emit(OpCodes.Ldarg_0);
                    object thisObject = null;
                    cursor.EmitDelegate<Func<object, object>>(o =>
                    {
                        thisObject = o;
                        return o;
                    });
                    cursor.Emit(OpCodes.Pop);

                    //gets current ray
                    cursor.Emit(OpCodes.Ldloc_S, byte.Parse("13"));
                    Ray thisRay = null;
                    cursor.EmitDelegate<Func<Ray, Ray>>(r =>
                    {
                        thisRay = r;
                        return r;
                    });
                    cursor.Emit(OpCodes.Pop);

                    //DynData<Ray> rayData2 = new DynData<Ray>(thisRay);
                    //Logger.Log("ScuffedHelper", $"Ray: {thisRay}, Obj: {thisObject}");

                    //replace colour
                    cursor.EmitDelegate<Func<Color, Color>>(c =>
                    {

                        if (thisObject.GetType() == typeof(CustomSurface) && thisRay != null) {
                            //get colour
                            DynData<Ray> rayData = new DynData<Ray>(thisRay);
                            // replace colour
                            Color thisRayColour = rayData.Get<Color>("RayColour");

                            //Logger.Log("ScuffedHelper", $"RayColour: {thisRayColour}");

                            return thisRayColour;
                        }
                        return c;
                    });
                }

                //fix ray mesh
                cursor = new ILCursor(il);

                while (cursor.TryGotoNext(MoveType.After, instr => instr.MatchLdsfld(rayTopColorField))) {

                    //fix mesh 
                    //vector appears to be direction to the "left" of the surface (if surface faces up, it faces left?)
                    //vector2 appears to be position along water surface

                    //the problem is with value3 and value4, as those can be outside the water
                    //so I just need to push value3 and value4 inside the water
                    /*
                    mesh[num7].Position = new Vector3(value, 0f);
                    mesh[num7].Color = RayTopColor * num8;
                    mesh[num7 + 1].Position = new Vector3(value2, 0f);
                    mesh[num7 + 1].Color = RayTopColor * num8;
                    mesh[num7 + 2].Position = new Vector3(value4, 0f);
                    mesh[num7 + 3].Position = new Vector3(value2, 0f);
                    mesh[num7 + 3].Color = RayTopColor * num8;
                    mesh[num7 + 4].Position = new Vector3(value3, 0f);
                    mesh[num7 + 5].Position = new Vector3(value4, 0f);
                    */
                }
            }

            #endregion

            readonly DynData<Surface> ThisSurfaceData;
            //find out what fills the surface and change that colour too
            public CustomSurface(FourSurfaceWater parent, Vector2 offset, Vector2 outwards, float width, float bodyHeight, 
                string RawSurfaceColour = origSurface, string RawRayColours = origRay, float RaysPerPixel = 0.2f, string RawFillColour = origFill, 
                float RayLengthLow = 8f, float RayLengthHigh = 128f) 
                : base(parent.Position + offset, outwards, width, bodyHeight) {

                Parent = parent;
                Offset = offset;

                //dyndata
                ThisSurfaceData = new DynData<Surface>(this);

                ThisSurfaceColour = ColourConversion.GetColour(RawSurfaceColour);
                ThisRayColours = ColourConversion.GetColourList(RawRayColours);
                ThisFillColour = ColourConversion.GetColour(RawFillColour);

                ThisRaysPerPixel = RaysPerPixel;

                this.RayLengthLow = RayLengthLow;
                this.RayLengthHigh = RayLengthHigh;

                //redo rays
                Rays.Clear();

                Random random = new Random();

                int num2 = (int)(width * RaysPerPixel);
                for (int i = 0; i < num2; i++) {
                    Ray thisRay = new Ray(Width);
                    Rays.Add(thisRay);

                    //add colour attribute to dyndata
                    DynData<Ray> rayData = new DynData<Ray>(thisRay);

                    
                    Color thisColour = ThisRayColours[random.Next(ThisRayColours.Count)];
                    //Logger.Log("Scuffed Helper", $"ThisColour: {thisColour}");
                    rayData["RayColour"] = thisColour; // set and get later
                    rayData["CustomSurfaceParent"] = this; // set and get later
                }

                //redo surface colour
                int surfaceStartIndex = ThisSurfaceData.Get<int>("surfaceStartIndex");
                VertexPositionColor[] mesh = ThisSurfaceData.Get<VertexPositionColor[]>("mesh");

                bool vertical = Outwards.Y == 0;

                int num = (int)(width / 4f);
                for (int l = surfaceStartIndex; l < surfaceStartIndex + num * 6; l++) {
                    mesh[l].Color = ThisSurfaceColour;

                }

                //redo fill colour
                int fillStartIndex = ThisSurfaceData.Get<int>("fillStartIndex");
                //if horizontal, might need to change things
                
                for (int j = fillStartIndex; j < fillStartIndex + num * 6; j++) {
                    mesh[j].Color = ThisFillColour;
                    //Logger.Log("Scuffed Helper", $"ThisFillColour: {ThisFillColour}");
                }

                ThisSurfaceData["mesh"] = mesh;

            }

            //speghetti, but hey it's not called "scuffed helper" for nothing
            public void FixMesh() {
                VertexPositionColor[] mesh = ThisSurfaceData.Get<VertexPositionColor[]>("mesh");

                //if horizontal, might need to change things
                bool vertical = Outwards.Y == 0;
                int num = (int)(Width / 4f);

                CustomSurface CustomTopSurface = Parent.GetCustomSurface(new Vector2(0, -1));
                CustomSurface CustomBottomSurface = Parent.GetCustomSurface(new Vector2(0, 1));
                CustomSurface CustomLeftSurface = Parent.GetCustomSurface(new Vector2(-1, 0));
                CustomSurface CustomRightSurface = Parent.GetCustomSurface(new Vector2(1, 0));

                //surface
                //this makes the edges sortof blend out but I really like how that looks so I'm keeping it
                int surfaceStartIndex = ThisSurfaceData.Get<int>("surfaceStartIndex");

                for (int j = surfaceStartIndex; j < surfaceStartIndex + num * 6; j += 6) {
                    //loop through groups
                    for (int k = j; k < j + 6; k++) {
                        if (vertical) {
                            //top
                            if (CustomTopSurface != null) {
                                if (mesh[k].Position.Y < CustomTopSurface.Position.Y - CustomTopSurface.GetSurfaceHeight(Convert(mesh[k].Position))) {
                                    mesh[k].Position.Y = CustomTopSurface.Position.Y - CustomTopSurface.GetSurfaceHeight(Convert(mesh[k].Position));
                                }
                            }

                            //bottom
                            if (CustomBottomSurface != null) {
                                if (mesh[k].Position.Y > CustomBottomSurface.Position.Y + CustomBottomSurface.GetSurfaceHeight(Convert(mesh[k].Position))) {
                                    mesh[k].Position.Y = CustomBottomSurface.Position.Y + CustomBottomSurface.GetSurfaceHeight(Convert(mesh[k].Position));
                                }
                            }
                        } else {
                            //left
                            if (CustomLeftSurface != null) {
                                if (mesh[k].Position.X < CustomLeftSurface.Position.X - CustomLeftSurface.GetSurfaceHeight(Convert(mesh[k].Position))) {
                                    mesh[k].Position.X = CustomLeftSurface.Position.X - CustomLeftSurface.GetSurfaceHeight(Convert(mesh[k].Position));
                                }
                            }

                            //right
                            if (CustomRightSurface != null) {
                                if (mesh[k].Position.X > CustomRightSurface.Position.X + CustomRightSurface.GetSurfaceHeight(Convert(mesh[k].Position))) {
                                    mesh[k].Position.X = CustomRightSurface.Position.X + CustomRightSurface.GetSurfaceHeight(Convert(mesh[k].Position));
                                }
                            }
                        }
                    }
                }

                //fill
                int fillStartIndex = ThisSurfaceData.Get<int>("fillStartIndex");

                for (int j = fillStartIndex; j < fillStartIndex + num * 6; j += 6) {
                    //loop through groups
                    bool flag = false;
                    for (int k = j; k < j + 6; k++) {
                        mesh[k].Color = ThisFillColour;
                        if (vertical) {
                            //top
                            if (CustomTopSurface != null) {
                                if (mesh[k].Position.Y < CustomTopSurface.Position.Y) {
                                    mesh[k].Position.Y = CustomTopSurface.Position.Y;
                                    //flag = true;
                                    //break;
                                }
                            }

                            //bottom
                            if (CustomBottomSurface != null) {
                                if (mesh[k].Position.Y > CustomBottomSurface.Position.Y) {
                                    mesh[k].Position.Y = CustomBottomSurface.Position.Y;
                                    //flag = true;
                                    //break;
                                }
                            }
                            //fix bottom surface
                        } else {
                            //left
                            if (CustomLeftSurface != null) {
                                if (mesh[k].Position.X < CustomLeftSurface.Position.X - CustomLeftSurface.GetSurfaceHeight(Convert(mesh[k].Position))) {
                                    mesh[k].Position.X = CustomLeftSurface.Position.X - CustomLeftSurface.GetSurfaceHeight(Convert(mesh[k].Position));
                                }
                            }

                            //right
                            if (CustomRightSurface != null) {
                                if (mesh[k].Position.X > CustomRightSurface.Position.X + CustomRightSurface.GetSurfaceHeight(Convert(mesh[k].Position))) {
                                    mesh[k].Position.X = CustomRightSurface.Position.X + CustomRightSurface.GetSurfaceHeight(Convert(mesh[k].Position));
                                }
                            }
                        }
                    }
                    if (flag == true) {
                        for (int k = j; k < j + 6; k++) {
                            mesh[k].Color = Color.Transparent;
                        }
                    }
                }
                    

                ThisSurfaceData["mesh"] = mesh;
            }

            private Vector2 Convert(Vector3 input) {
                return new Vector2(input.X, input.Y);
            }

            public void UpdatePosition() {
                Position = Parent.Position + Offset;
            }

            public Vector2 GetSide(bool right) {
                Vector2 vector = Outwards.Perpendicular();
                if (right) {
                    return Position + vector * (-Width / 2);
                }
                return Position + vector * (Width / 2);

            }

            public static void Mod_RayReset(On.Celeste.Water.Ray.orig_Reset orig, Ray ray, float percent)
            {
                orig(ray, percent);

                // change length
                DynData<Ray> rayData = new DynData<Ray>(ray);
                if(rayData["CustomSurfaceParent"] != null)
                {
                    CustomSurface cs = (CustomSurface)rayData["CustomSurfaceParent"];
                    ray.Length = Calc.Random.Range(cs.RayLengthLow, cs.RayLengthHigh);
                }
            }

        }

        /*
        private Surface CustomTopSurface;
        private Surface CustomLeftSurface;
        private Surface CustomBottomSurface;
        private Surface CustomRightSurface;

        private float CustomTopSurfaceRays;
        private float CustomLeftSurfaceRays;
        private float CustomBottomSurfaceRays;
        private float CustomRightSurfaceRays;
        */

        private Color fillColour;
        private DynData<Water> Data;
        private DynData<Engine> EngineData;

        public FourSurfaceWater(EntityData data, Vector2 offset, EntityID id) : base(data.Position + offset, data.Bool("hasTop"), data.Bool("hasBottom"), data.Width, data.Height) {
            //Logger.Log("TestCodeMod/CustomWater", $"{data}");
            //clear surfaces
            Surfaces.Clear();

            Data = new DynData<Water>(this);
            EngineData = new DynData<Engine>(Engine.Instance);

            string rawFillColour = data.Attr("fillColour", "87cefa4d");
            fillColour = ColourConversion.GetColour(rawFillColour);

            raysContained = data.Bool("containRays", false);

            int num = 8;

            DynData<Water> waterData = new DynData<Water>(this);
            Rectangle fill = (Rectangle) waterData["fill"];
            /*
            fill.Y += 1;
            waterData["fill"] = fill;
            */

            //code is very repetitive
            #region Surfaces
            //top surface
            if (data.Bool("hasTop", false)) {
                CustomSurface CustomTopSurface = new CustomSurface(this, new Vector2(Width / 2f, num), new Vector2(0f, -1f), Width, Height, 
                    data.Attr("topSurfaceColour", origSurface), data.Attr("topRayColours", origRay), data.Float("topRaysDensity", 0.2f), 
                    rawFillColour, data.Float("topRaysLengthLow", 8), data.Float("topRaysLengthHigh", 128));

                Surfaces.Add(CustomTopSurface);
            }

            //left surface
            if (data.Bool("hasLeft", false)) {
                CustomSurface CustomLeftSurface = new CustomSurface(this, new Vector2(num, Height / 2), new Vector2(-1, 0), Height, Width,
                    data.Attr("leftSurfaceColour", origSurface), data.Attr("leftRayColours", origRay), data.Float("leftRaysDensity", 0.2f), 
                    rawFillColour, data.Float("leftRaysLengthLow", 8), data.Float("leftRaysLengthHigh", 128));

                Surfaces.Add(CustomLeftSurface);
                fill = (Rectangle)waterData["fill"];
                fill.Width -= num;
                fill.X += num;
                waterData["fill"] = fill;
            }

            //bottom surface
            if (data.Bool("hasBottom", false)) {
                CustomSurface CustomBottomSurface = new CustomSurface(this, new Vector2(Width / 2f, Height - num), new Vector2(0f, 1f), Width, Height,
                    data.Attr("bottomSurfaceColour", origSurface), data.Attr("bottomRayColours", origRay), data.Float("bottomRaysDensity", 0.2f), rawFillColour,
                    data.Float("bottomRaysLengthLow", 8), data.Float("bottomRaysLengthHigh", 128));

                Surfaces.Add(CustomBottomSurface);
            }

            //right surface
            if (data.Bool("hasRight", false)) {
                CustomSurface CustomRightSurface = new CustomSurface(this, new Vector2(Width - num, Height / 2), new Vector2(1, 0), Height, Width,
                    data.Attr("rightSurfaceColour", origSurface), data.Attr("rightRayColours", origRay), data.Float("rightRaysDensity", 0.2f), rawFillColour,
                    data.Float("rightRaysLengthLow", 8), data.Float("rightRaysLengthHigh", 128));

                Surfaces.Add(CustomRightSurface);
                fill = (Rectangle)waterData["fill"];
                fill.Width -= num;
                waterData["fill"] = fill;
            }

            /*
            foreach(CustomSurface s in Surfaces) {
                s.SetTension(s.GetSide(false), 0.1f);
                s.SetTension(s.GetSide(true), 0.1f);
            }
            */
            #endregion

        }

        public CustomSurface GetCustomSurface(Vector2 outwards) {
            foreach (CustomSurface s in Surfaces) {
                if (s.Outwards == outwards) {
                    return s;
                }
            }
            return null;
        }

        //add ripples to side surfaces
            //does not work at the moment (presumably due to custom surfaces deleting ripples)
        public override void Update() {
            base.Update();
            
            /*
            foreach (WaterInteraction component in base.Scene.Tracker.GetComponents<WaterInteraction>()) {
                Rectangle bounds = component.Bounds;
                Vector2 boundsCentre = new Vector2(bounds.Center.X, bounds.Center.Y);
                bool flag = Data.Get<HashSet<WaterInteraction>>("contains").Contains(component);
                bool flag2 = CollideRect(bounds);
                if (flag != flag2) {
                    Vector2 direction = (boundsCentre - Center).FourWayNormal();
                    GetCustomSurface(-direction)?.DoRipple(bounds.Center.ToVector2(), 1f);
                    Logger.Log("Scuffed Helper", $"{direction}, {GetCustomSurface(-direction)}");
                }

                if (flag) {
                    Data.Get<HashSet<WaterInteraction>>("contains").Remove(component);
                } else {
                    Data.Get<HashSet<WaterInteraction>>("contains").Add(component);
                }
            }
            */
            
        }

        public override void Render() {
            
            // Why is this not logging?
            foreach (CustomSurface s in Surfaces)
            {
                Logger.Log("Scuffed Helper", $"Surface: {s.Position}");
            }
            Logger.Log("Scuffed Helper", $"Pos: {Position}");

            //also move surfaces
            if (!Engine.Scene.Paused) {
                //workaround, so waves don't move at double speed
                float oldDeltaTime = Engine.DeltaTime;
                EngineData["DeltaTime"] = 0f;
                foreach (CustomSurface s in Surfaces) {
                    s.Update();
                }
                EngineData["DeltaTime"] = oldDeltaTime;
            }

            fillColorField.SetValue(null, fillColour);
            float OldPosY = Position.Y;
            //check the name of the helper
            //Position.Y += 0.5f;

            base.Render();

            Position.Y = OldPosY;
            fillColorField.SetValue(null, ColourConversion.GetColour(origFill));
        }
    }
}
