﻿using Microsoft.Xna.Framework;
using Monocle;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Celeste.Mod.ScuffedHelper {
    internal class ColourConversion {

        public static Color GetColour(string Colour) {
            Colour = Colour.Replace("#", "").Trim();

            //take substring so that calc.HexToColor doesn't yell at me
            Color returnColour = Calc.HexToColor(Colour.Substring(0, 6));

            //get the last 7th and 8th chars in string, and make byte
            float alpha;
            try {
                alpha = (Calc.HexToByte(Colour[6]) * 16 + Calc.HexToByte(Colour[7])) / 255f;
            }catch(IndexOutOfRangeException e) {
                alpha = 1;
            }
            
            
            return returnColour * alpha;
        }

        public static List<Color> GetColourList(string Colours) {
            List<Color> returnColours = new List<Color>();
            foreach(string c in Colours.Split(',')) {
                returnColours.Add(GetColour(c));
            }

            return returnColours;
        }

    }
}
