module ScuffedHelperWaterBerry
using ..Ahorn, Maple

#define properties of entity
@mapdef Entity "ScuffedHelper/WaterBerry" WaterBerry(
    x::Integer, 
    y::Integer)

#save placements
const placements = Ahorn.PlacementDict(
    "Water Berry (Scuffed Helper)" => Ahorn.EntityPlacement(
        WaterBerry
    )
)

#get selection box
function Ahorn.selection(entity::WaterBerry)
    x, y = Ahorn.position(entity)

    return Ahorn.Rectangle(x - 7, y - 7, 14, 14)
end

#render

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::WaterBerry, room::Maple.Room) = Ahorn.drawSprite(ctx, "collectables/waterberry/waterberry03", 0, 0)

end