module ScuffedHelperSetWaterDashesEntity
using ..Ahorn, Maple

#define properties of entity
@mapdef Entity "ScuffedHelper/SetWaterDashesEntity" SetWaterDashesEntity(
    x::Integer, 
    y::Integer,
    isEnabled::Bool=true,
    isPersistent::Bool=true,
    waterDashes::Integer = 3,
    waterDashHairColour::String = "#0000FF"
    )

#save placements
const placements = Ahorn.PlacementDict(
    "Set Water Dashes Entity (Scuffed Helper)" => Ahorn.EntityPlacement(
        SetWaterDashesEntity
    )
)

#get selection box
function Ahorn.selection(entity::SetWaterDashesEntity)
    x, y = Ahorn.position(entity)

    return Ahorn.Rectangle(x - 12, y - 12, 24, 24)
end

#render

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::SetWaterDashesEntity, room::Maple.Room) = Ahorn.drawSprite(ctx, "ahorn/Water Dash/SetWaterDashCountIcon", 0, 0)

end