module ScuffedHelperRandomSpinner
using ..Ahorn, Maple

#define properties of entity
@mapdef Entity "ScuffedHelper/RandomSpinner" RandomSpinner(
    x::Integer, 
    y::Integer,
    chance::Integer=2
    )

#save placements
const placements = Ahorn.PlacementDict(
    "Random Spinner (Scuffed Helper)" => Ahorn.EntityPlacement(
        RandomSpinner
    )
)

#get selection box
function Ahorn.selection(entity::RandomSpinner)
    x, y = Ahorn.position(entity)

    return Ahorn.Rectangle(x - 8, y - 8, 16, 16)
end

#render

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::RandomSpinner, room::Maple.Room)
    Ahorn.drawSprite(ctx, "danger/crystal/fg_blue03", 0, 0)
end

end